

// BICurrency.h
// BISubstrate
// 
// Copyright (c) 2008 Marketcircle Inc. All rights reserved.


#ifdef BILLINGS_PRO
#import "_BPCurrency.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BICurrency.h"
#endif
#import "BIAppVersioning.h"

@class BICurrencyRepresentation;

@interface BICurrency : BL_SUPER_CLASSNAME_MUNGE(Currency)
{
	NSNumberFormatter *currencyFormatter;
}

+ (NSDecimalNumber *)baseCurrencyValueForForeignValue:(NSNumber *)foreignVal 
								   exchangeRateToBase:(NSNumber *)aFloatValue;


- (NSDecimalNumber *)baseCurrencyValueForForeignValue:(NSNumber *)foreignVal;

/*!
 What does 500 in foreign currency equal to in base currency
 */
- (NSDecimalNumber *)baseValueForExample;

- (NSDecimalNumber *)exampleValue;
- (NSString *)formattedExampleValue;

- (NSString *)exampleStringFromBaseCurrency:(BICurrency *)base;
- (NSString *)exampleString;


/*!
 Setups the currency appropriately based on the user selection (see NSLocale+BIAdditions)
 */
- (void)setCurrencyRepresentation:(BICurrencyRepresentation *)aRep;


/*!
 Returns the number formatter formatted with the currency code and symbol
 */
- (NSNumberFormatter *)currencyFormatter;

/*!
 Display string with the currency code and symbol separated by a space
 */
- (NSString *)codeAndSymbol;

/*!
 Name resolved from the currency code using the current local. Should be localization friendly.
 */
- (NSString *)resolvedName;

/**
 Returns YES if the update completed successfully or NO if failed.
 */
- (BOOL)updateExchangeRate;

- (void)migrateToLatestIfNeeded;

@end
